

<?php $__env->startSection('title', 'Doctor Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">Doctor Details</h1>
        <div class="flex gap-2">
            <a href="<?php echo e(route('admin.doctors')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Doctors</span><span class="sm:hidden">Back</span>
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6 mb-6">
        <!-- Main Information -->
        <div class="lg:col-span-2 bg-white rounded-lg shadow p-4 sm:p-6">
            <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6">Personal Information</h2>
            
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6 mb-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->title ?? 'N/A'); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">First Name</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->first_name); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Last Name</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->last_name); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->email); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Phone</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->phone ?? 'N/A'); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Country</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->country ?? 'N/A'); ?></p>
                </div>
            </div>

            <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 mt-6">Professional Information</h2>
            
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6 mb-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Practice Number</label>
                    <p class="text-sm sm:text-base text-gray-900 font-semibold"><?php echo e($doctor->practice_number); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Specialization</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->specialization ?? 'N/A'); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Qualification</label>
                    <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->qualification ?? 'N/A'); ?></p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                    <div class="mt-1">
                        <?php if($doctor->is_verified && $doctor->is_active): ?>
                            <span class="px-3 py-1 text-xs sm:text-sm rounded-full bg-green-100 text-green-800 font-semibold">Active & Verified</span>
                        <?php elseif($doctor->is_verified && !$doctor->is_active): ?>
                            <span class="px-3 py-1 text-xs sm:text-sm rounded-full bg-yellow-100 text-yellow-800 font-semibold">Verified but Inactive</span>
                        <?php else: ?>
                            <span class="px-3 py-1 text-xs sm:text-sm rounded-full bg-red-100 text-red-800 font-semibold">Pending Verification</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if($doctor->educational_details): ?>
            <div class="mb-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Educational Details</label>
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-sm sm:text-base text-gray-900 whitespace-pre-wrap"><?php echo e($doctor->educational_details); ?></p>
                </div>
            </div>
            <?php endif; ?>

            <?php if($doctor->verified_at): ?>
            <div class="mb-6">
                <label class="block text-sm font-medium text-gray-700 mb-1">Verified At</label>
                <p class="text-sm sm:text-base text-gray-900"><?php echo e($doctor->verified_at->format('F d, Y \a\t g:i A')); ?></p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Profile Picture & Actions -->
        <div class="bg-white rounded-lg shadow p-4 sm:p-6">
            <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6">Profile Picture</h2>
            
            <?php if($doctor->profile_picture_path): ?>
                <div class="mb-4">
                    <img src="<?php echo e(asset('storage/' . $doctor->profile_picture_path)); ?>" 
                         alt="<?php echo e($doctor->full_name); ?>" 
                         class="w-full rounded-lg shadow-md object-cover">
                </div>
            <?php else: ?>
                <div class="bg-gray-200 rounded-lg p-8 text-center mb-4">
                    <i class="fas fa-user text-gray-400 text-6xl"></i>
                    <p class="text-gray-500 mt-2 text-sm">No profile picture</p>
                </div>
            <?php endif; ?>

            <div class="space-y-3">
                <?php if(!$doctor->is_verified): ?>
                    <form method="POST" action="<?php echo e(route('admin.doctors.verify', $doctor->id)); ?>" class="w-full">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded text-sm sm:text-base">
                            <i class="fas fa-check-circle"></i> Verify Doctor
                        </button>
                    </form>
                <?php endif; ?>
                
                <form method="POST" action="<?php echo e(route('admin.doctors.toggle-status', $doctor->id)); ?>" class="w-full">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm sm:text-base">
                        <i class="fas fa-toggle-<?php echo e($doctor->is_active ? 'on' : 'off'); ?>"></i> 
                        <?php echo e($doctor->is_active ? 'Deactivate' : 'Activate'); ?> Doctor
                    </button>
                </form>
                
                <form method="POST" action="<?php echo e(route('admin.doctors.delete', $doctor->id)); ?>" 
                      class="w-full" 
                      onsubmit="return confirm('Are you sure you want to delete this doctor? This action cannot be undone.')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="w-full bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded text-sm sm:text-base">
                        <i class="fas fa-trash"></i> Delete Doctor
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Attachments Section -->
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-6">
        <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6">Uploaded Documents</h2>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6">
            <!-- Letterhead -->
            <div class="border rounded-lg p-4">
                <h3 class="text-sm font-semibold text-gray-700 mb-3">Letterhead</h3>
                <?php if($doctor->letterhead_path): ?>
                    <div class="mb-3">
                        <img src="<?php echo e(asset('storage/' . $doctor->letterhead_path)); ?>" 
                             alt="Letterhead" 
                             class="w-full rounded border object-contain max-h-48 cursor-pointer hover:opacity-75 transition"
                             onclick="openImageModal('<?php echo e(asset('storage/' . $doctor->letterhead_path)); ?>', 'Letterhead')">
                    </div>
                    <a href="<?php echo e(asset('storage/' . $doctor->letterhead_path)); ?>" 
                       target="_blank" 
                       class="text-blue-600 hover:text-blue-900 text-sm">
                        <i class="fas fa-external-link-alt"></i> View Full Size
                    </a>
                <?php else: ?>
                    <div class="bg-gray-100 rounded p-4 text-center">
                        <i class="fas fa-file-image text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-500 text-xs">Not uploaded</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Stamp -->
            <div class="border rounded-lg p-4">
                <h3 class="text-sm font-semibold text-gray-700 mb-3">Stamp</h3>
                <?php if($doctor->stamp_path): ?>
                    <div class="mb-3">
                        <img src="<?php echo e(asset('storage/' . $doctor->stamp_path)); ?>" 
                             alt="Stamp" 
                             class="w-full rounded border object-contain max-h-48 cursor-pointer hover:opacity-75 transition"
                             onclick="openImageModal('<?php echo e(asset('storage/' . $doctor->stamp_path)); ?>', 'Stamp')">
                    </div>
                    <a href="<?php echo e(asset('storage/' . $doctor->stamp_path)); ?>" 
                       target="_blank" 
                       class="text-blue-600 hover:text-blue-900 text-sm">
                        <i class="fas fa-external-link-alt"></i> View Full Size
                    </a>
                <?php else: ?>
                    <div class="bg-gray-100 rounded p-4 text-center">
                        <i class="fas fa-stamp text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-500 text-xs">Not uploaded</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Signature -->
            <div class="border rounded-lg p-4">
                <h3 class="text-sm font-semibold text-gray-700 mb-3">Signature</h3>
                <?php if($doctor->signature_path): ?>
                    <div class="mb-3">
                        <img src="<?php echo e(asset('storage/' . $doctor->signature_path)); ?>" 
                             alt="Signature" 
                             class="w-full rounded border object-contain max-h-48 cursor-pointer hover:opacity-75 transition"
                             onclick="openImageModal('<?php echo e(asset('storage/' . $doctor->signature_path)); ?>', 'Signature')">
                    </div>
                    <a href="<?php echo e(asset('storage/' . $doctor->signature_path)); ?>" 
                       target="_blank" 
                       class="text-blue-600 hover:text-blue-900 text-sm">
                        <i class="fas fa-external-link-alt"></i> View Full Size
                    </a>
                <?php else: ?>
                    <div class="bg-gray-100 rounded p-4 text-center">
                        <i class="fas fa-signature text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-500 text-xs">Not uploaded</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Profile Picture (Duplicate for consistency) -->
            <div class="border rounded-lg p-4">
                <h3 class="text-sm font-semibold text-gray-700 mb-3">Profile Picture</h3>
                <?php if($doctor->profile_picture_path): ?>
                    <div class="mb-3">
                        <img src="<?php echo e(asset('storage/' . $doctor->profile_picture_path)); ?>" 
                             alt="Profile Picture" 
                             class="w-full rounded border object-contain max-h-48 cursor-pointer hover:opacity-75 transition"
                             onclick="openImageModal('<?php echo e(asset('storage/' . $doctor->profile_picture_path)); ?>', 'Profile Picture')">
                    </div>
                    <a href="<?php echo e(asset('storage/' . $doctor->profile_picture_path)); ?>" 
                       target="_blank" 
                       class="text-blue-600 hover:text-blue-900 text-sm">
                        <i class="fas fa-external-link-alt"></i> View Full Size
                    </a>
                <?php else: ?>
                    <div class="bg-gray-100 rounded p-4 text-center">
                        <i class="fas fa-user text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-500 text-xs">Not uploaded</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div id="imageModal" class="hidden fixed inset-0 bg-black bg-opacity-75 z-50 flex items-center justify-center p-4" onclick="closeImageModal()">
    <div class="bg-white rounded-lg max-w-4xl w-full max-h-[90vh] overflow-auto" onclick="event.stopPropagation()">
        <div class="flex justify-between items-center p-4 border-b">
            <h3 id="modalTitle" class="text-lg font-bold"></h3>
            <button onclick="closeImageModal()" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        <div class="p-4">
            <img id="modalImage" src="" alt="" class="w-full h-auto rounded">
        </div>
    </div>
</div>

<script>
function openImageModal(imageSrc, title) {
    document.getElementById('modalImage').src = imageSrc;
    document.getElementById('modalTitle').textContent = title;
    document.getElementById('imageModal').classList.remove('hidden');
    document.body.style.overflow = 'hidden';
}

function closeImageModal() {
    document.getElementById('imageModal').classList.add('hidden');
    document.body.style.overflow = 'auto';
}

// Close modal on Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeImageModal();
    }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/doctor-details.blade.php ENDPATH**/ ?>